<?php

namespace App\Admin\Controllers;

use App\Admin\Metrics\Examples;
use App\Http\Controllers\Controller;
use App\Models\Good;
use App\Models\OrderInfo;
use Dcat\Admin\Http\Controllers\Dashboard;
use Dcat\Admin\Layout\Column;
use Dcat\Admin\Grid;
use Dcat\Admin\Layout\Content;
use Dcat\Admin\Layout\Row;
use Dcat\Admin\Widgets\Card;
use Dcat\Admin\Widgets\Dropdown;
use Dcat\Admin\Widgets\Box;
use Dcat\Admin\Admin;
use Dcat\Admin\Form;

class HomeController extends Controller
{
    public function index(Content $content)
    {
        // 创建表单构建器
        $form = Form::make()->action(admin_url('orderInfo'));

        // 添加日期范围搜索
        $form->dateRange('date', '日期范围')->default(function () {
            return [
                date('Y-m-d 00:00:00', strtotime('-1 day')),
                date('Y-m-d 23:59:59', strtotime('-1 day'))
            ];
        });

        // 添加搜索按钮
        //$form->disableResetBtn();
        //$form->submit('搜索');

        // 使用卡片视图展示统计数据
        $card123 = Card::make('统计数据')
            ->content(function () use ($form) {
                // 获取表单提交的日期参数
                $dates = $form->getFieldValue('date');

                // // 查询数据库，这里以AdminLog为例
                //$logs = OrderInfo::whereBetween('created_at', $dates)->get();

                // // 统计数据
                // $count = $logs->count();

                return "共有记录 100 条";
            });
        //-----
        // 构建下拉菜单，当点击菜单时发起请求获取数据重新渲染图表
        $menu = [
            '7'  => '最近7天',
            '30' => '最近30天',
            '365' => '最近一年',
        ];
        $dropdown = Dropdown::make($menu)
            ->button(current($menu))
            ->click()
            ->map(function ($v, $k) {
                // 此处设置的 data-xxx 属性会作为post数据发送到后端api
                return "<a class='switch-bar' data-option='{$k}'>{$v}</a>";
            });

        // 传递自定义参数
        $id = 1;
        $username = 'jack';

        $bar = Examples\OrderAjaxBar::make($id, $username)
            ->fetching('$("#my-box").loading()') // 设置loading效果
            ->fetched('$("#my-box").loading(false)') // 移除loading效果
            ->click('.switch-bar'); // 设置图表点击菜单则重新发起请求，且被点击的目标元素上的 data-xxx 属性会被作为post数据发送到后端API

        $box = Box::make('销售额趋势', $bar)
            ->id('my-box') // 设置盒子的ID
            ->tool($dropdown); // 设置下拉菜单按钮
        //------
        //商品列表
        $goodsQuery = Good::where('is_show', 0)->orderBy('created_at', 'desc');
        return $content
            ->header('Dashboard')
            ->description('Description...')
            ->body(function (Row $row) use ($box, $goodsQuery, $card123) {
                //$row->column(12, $card123);

                $row->column(12, function (Column $column) use ($box, $goodsQuery) {
                    $column->row(function (Row $row) use ($box, $goodsQuery) {
                        $row->column(6, new Examples\OrderWaitCount());
                        $row->column(6, new Examples\OrderPickCount());
                        //$row->column(12, Card::make('订单信息', Examples\MyBar::make()));
                        $row->column(12, Card::make('订单信息', $box));
                        $row->column(12, new Examples\Product());
                        // $row->column(12, function (Column $column) use ($goodsQuery) {
                        //     $column->row(
                        //         Grid::make($goodsQuery, function (Grid $grid) {
                        //             $grid->disableRefreshButton();
                        //             $grid->disableCreateButton();
                        //             $grid->disableActions();
                        //             $grid->disableRowSelector();
                        //             $grid->addTableClass(['table-text-left']);
                        //             //$grid->simplePaginate();
                        //             $grid->column('cover_img', '商品图片')->image('', 100, 100)->width(280);
                        //             $grid->column('goods_name', '商品名称');
                        //             $grid->column('sale', '销量')->width(250);
                        //         })
                        //     );
                        // });
                    });
                });


                // $row->column(12,'欢迎登录');
            });
    }
}
