<?php

namespace App\Admin\Controllers;

use App\Models\Comment;
use Dcat\Admin\Form;
use Dcat\Admin\Grid;
use Dcat\Admin\Show;
use Dcat\Admin\Http\Controllers\AdminController;

class CommentController extends AdminController
{
    /**
     * Make a grid builder.
     *
     * @return Grid
     */
    protected function grid()
    {
        return Grid::make(Comment::with(['goods']), function (Grid $grid) {
            $grid->model()->orderBy('created_at', 'DESC');
            $grid->column('id')->sortable();
            $grid->column('goods.goods_name', '商品标题');
            $grid->column('avatar', '用户头像')->image('', 100, 100);
            $grid->column('nickname', '用户昵称');
            $grid->column('phone', '用户手机');
            $grid->column('content', '评价内容')->limit(20);
            $grid->column('addtime', '评价时间');
            // $grid->column('updated_at')->sortable();
            $grid->disableViewButton();
            $grid->disableEditButton();
            $grid->filter(function (Grid\Filter $filter) {
                // 更改为 panel 布局
                $filter->panel();
                $filter->like('goods.goods_name', '商品标题')->width(3);
                $filter->like('phone', '用户手机')->width(3);
            });
        });
    }

    /**
     * Make a show builder.
     *
     * @param mixed $id
     *
     * @return Show
     */
    protected function detail($id)
    {
        return Show::make($id, new Comment(), function (Show $show) {
            $show->field('id');
            $show->field('title');
            $show->field('nickname');
            $show->field('avatar');
            $show->field('phone');
            $show->field('content');
            $show->field('created_at');
            $show->field('updated_at');
        });
    }

    /**
     * Make a form builder.
     *
     * @return Form
     */
    protected function form()
    {
        return Form::make(new Comment(), function (Form $form) {
            $form->display('id');
            $form->number('goods_id', "商品编号")->help('商品列表序号ID');
            $form->datetime('addtime', '评价时间')
                ->format('YYYY-MM-DD HH:mm:ss');
            $form->text('nickname');
            $form->text('phone');
            $form->number('star', '满意度')->min(1)->max(5)->default(5);

            $form->textarea('content');
            $form->image('avatar', '头像')
                ->url('upload/user')
                ->autoUpload();

            $form->disableCreatingCheck();
            $form->disableEditingCheck();
            $form->disableViewCheck();
            $form->disableDeleteButton();
            $form->disableViewButton();
        });
    }
}
