<?php

namespace App\Admin\Actions;

use Dcat\Admin\Actions\Response;
use App\Admin\Forms\BuyCodeForm;
use App\Models\User;
use Dcat\Admin\Grid\RowAction;
use Dcat\Admin\Traits\HasPermissions;
use Illuminate\Contracts\Auth\Authenticatable;
use Illuminate\Http\Request;
use Dcat\Admin\Widgets\Modal;

class UserBuyCode extends RowAction
{

    /**
     * @return string
     */
    protected $title = '<i class="feather icon-stop-circle"> 直购码 </i>';
    /**
     * 按钮文本
     *
     * @return string|void
     */
    public function title()
    {
        return '<i class="feather icon-edit"></i> ' . '直购码';
    }
    /**
     * Handle the action request.
     *
     * @param Request $request 
     *
     * @return Response
     */
    public function handle(Request $request)
    {
        $id = $this->getKey() ?? 0;

        return $this->response()->success('成功')->refresh();
    }


    /**
     * 渲染模态框.
     * @return Modal
     */
    public function render()
    {
        $user_id = $this->getKey() ?? 0;
        $userObj = User::find($user_id);
        $code = $userObj->buycode ?? '';
        // 这里直接创建一个modal框 model的内容由工具表单提供，这里也需要创建一个工具表单才行
        return Modal::make()
            ->lg()
            ->title('直购码')
            ->button($this->title())
            ->body(BuyCodeForm::make())
            ->onShown(
                <<<js
                $(document).ready(function () {
                    var colen = '{$code}';
                    if(colen.length > 0) {
                        $(".field_current").html('{$code}');
                    }
                    $(".field_userid").val('{$user_id}');
                });
            js
            );
        //->button("<button class='btn btn-sm btn-primary'>$this->title</button>"); // 这个button就是对应上面的按钮
    }

    /**
     * @return string|array|void
     */
    public function confirm()
    {
        // return ['Confirm?', 'contents'];
    }

    /**
     * @param Model|Authenticatable|HasPermissions|null $user
     *
     * @return bool
     */
    protected function authorize($user): bool
    {
        return true;
    }

    /**
     * @return array
     */
    protected function parameters()
    {
        return [];
    }
}
