<?php

namespace App\Admin\Actions;

use Dcat\Admin\Actions\Response;
use App\Admin\Forms\TransferBillsPlatForm;
use Dcat\Admin\Grid\RowAction;
use Dcat\Admin\Traits\HasPermissions;
use Illuminate\Contracts\Auth\Authenticatable;
use Illuminate\Http\Request;
use Dcat\Admin\Widgets\Modal;

class TransferToPlatForm extends RowAction
{
    protected $id = 0;
    /**
     * 接收参数
     */
    public function __construct($title = '', $id = 0)
    {
        $this->id = $id;
        parent::__construct($title);
        $this->title = $title;
    }

    /**
     * 按钮文本
     *
     * @return string|void
     */
    public function title()
    {
        return '<i class="feather icon-edit"></i> ' . $this->title;
    }
    /**
     * Handle the action request.
     *
     * @param Request $request 
     *
     * @return Response
     */
    public function handle(Request $request)
    {
        $id = $this->getKey() ?? 0;

        return $this->response()->success('成功')->refresh();
    }


    /**
     * 渲染模态框.
     * @return Modal
     */
    public function render()
    {
        // 这里直接创建一个modal框 model的内容由工具表单提供，这里也需要创建一个工具表单才行
        return Modal::make()
            ->lg()
            ->title($this->title)
            ->button($this->title())
            ->body(TransferBillsPlatForm::make()->payload(['id' => $this->id]));
    }

    /**
     * @return string|array|void
     */
    public function confirm()
    {
        //return ['Confirm?', 'contents'];
    }

    /**
     * @param Model|Authenticatable|HasPermissions|null $user
     *
     * @return bool
     */
    protected function authorize($user): bool
    {
        return true;
    }

    /**
     * @return array
     */
    protected function parameters()
    {
        return [];
    }
}
