<?php

namespace App\Admin\Actions;

use Dcat\Admin\Actions\Response;
use App\Admin\Forms\MerchantStoreForms;
use App\Models\Good;
use Dcat\Admin\Grid\RowAction;
use Dcat\Admin\Traits\HasPermissions;
use Illuminate\Contracts\Auth\Authenticatable;
//use Illuminate\Database\Eloquent\Model;
use Illuminate\Http\Request;
use Dcat\Admin\Widgets\Modal;
use App\Models\GoodSku;
use App\Models\MerchantGoodSku;

class MerchantStore extends RowAction
{

    protected $title = '';

    protected $goods_id = 0;

    /**
     * 接收参数
     * @type 1:增加库存 2：减少库存
     */
    public function __construct($title = '', $goods_id = 0)
    {
        $this->goods_id = $goods_id;
        parent::__construct($title);
        $this->title = $title;
    }
    /**
     * @return string
     */
    //protected $title = '<i class="feather icon-stop-circle"> 增加库存 </i>';
    /**
     * 按钮文本
     *
     * @return string|void
     */
    public function title()
    {
        return '<i class="feather icon-stop-circle"></i> ' . $this->title . '';
    }
    /**
     * Handle the action request.
     *
     * @param Request $request 
     *
     * @return Response
     */
    public function handle(Request $request)
    {
        $id = $this->getKey() ?? 0;

        return $this->response()->success('成功')->refresh();
    }


    /**
     * 渲染模态框.
     * @return Modal
     */
    public function render()
    {
        $mgs_id = $this->getKey() ?? 0;
        $goodObj = Good::where("id", $this->goods_id)->first();

        //获取商品规格信息
        $gid = $this->goods_id;
        $dataList = GoodSku::where("goods_id", $gid)->get();
        foreach ($dataList as $kk => $vv) {
            $dataList[$kk]['attr_id'] = $vv->id;
            //获取商户库存信息
            $merStock = MerchantGoodSku::where(['goods_id' => $gid, 'attr_id' => $vv->id])->sum('stock');
            $dataList[$kk]['stock'] = $vv->stock - $merStock;
        }

        $dataArr = $dataList ? $dataList->toArray() : [];

        $html = '';
        foreach ($dataArr as $kk => $vv) {
            $html .= '<tr>';
            $html .= '<input type="hidden" name="goods_id" value="' . $this->goods_id . '">';
            $html .= '<input type="hidden" name="mgs_id" value="' . $mgs_id . '">';
            $html .= '<td style="text-align:center;vertical-align: middle;">' . $goodObj->goods_name . '<input type="hidden" name="attr_id[]" value="' . $vv['attr_id'] . '"></td>';
            $html .= '<td style="text-align:center;vertical-align: middle;">' . $vv['attr_val'] . '</td>';
            $html .= '<td ><input type="text" name="stock[]" value="" class="form-control field_remark _normal_" placeholder=""></td>';
            $html .= '<td style="text-align:center;vertical-align: middle;">' . $vv['stock'] . '</td>';
            $html .= '</tr>';
        }
        // 这里直接创建一个modal框 model的内容由工具表单提供，这里也需要创建一个工具表单才行
        return Modal::make()
            ->lg()
            ->title($this->title)
            ->button("$this->title")
            // ->body('<form action="' . $actionUrl . '" method="post" class="form-horizontal" accept-charset="UTF-8" pjax-container="1" >
            //         <div class="row">
            //             <div class="col-md-12">
            //                 <table class="table">
            //                     <thead>
            //                         <tr>
            //                             <th width="20%" style="text-align:center;">商品名称</th>
            //                             <th width="20%" style="text-align:center;">商品规格</th>
            //                             <th width="20%" style="text-align:center;">增加库存</th>
            //                             <th width="20%" style="text-align:center;">剩余库存</th>
            //                         </tr>
            //                     </thead>
            //                     <tbody>
            //                         <!-- 表格数据 -->
            //                         <!--<tr>
            //                             <td style="text-align:center;vertical-align: middle;">数据1</td>
            //                             <td style="text-align:center;vertical-align: middle;">蓝色、大号</td>
            //                             <td ><input type="text" name="remark" value="" class="form-control field_remark _normal_" placeholder=""></td>
            //                             <td style="text-align:center;vertical-align: middle;">123</td>
            //                         </tr>-->
            //                         ' . $html . '
            //                         <!-- 更多行数据 -->
            //                     </tbody>
            //                 </table>
            //             </div>
            //             <div class="col-md-8"><button type="submit" class="btn btn-primary pull-right"><i class="feather icon-save"></i> 提交</button></div>
            //         </div>
            //     </form>
            // ');
            ->body(MerchantStoreForms::make(['id' => $mgs_id]))
            ->onShown(
                <<<js
                    $(document).ready(function () {
                        console.log('{$html}');
                        $("#tabletr").html('"+ $html +"');
                    });
                js
            );
        //->button("<button class='btn btn-sm btn-primary'>$this->title</button>"); // 这个button就是对应上面的按钮
    }

    /**
     * @return string|array|void
     */
    public function confirm()
    {
        // return ['Confirm?', 'contents'];
    }

    /**
     * @param Model|Authenticatable|HasPermissions|null $user
     *
     * @return bool
     */
    protected function authorize($user): bool
    {
        return true;
    }

    /**
     * @return array
     */
    protected function parameters()
    {
        return [];
    }
}
