import request from '@/utils/request'

// 查询商品标签列表
export function listGoodsTag(query) {
  return request({
    url: '/system/goodsTag/list',
    method: 'get',
    params: query
  })
}

// 查询商品标签详细
export function getGoodsTag(id) {
  return request({
    url: '/system/goodsTag/' + id,
    method: 'get'
  })
}

// 新增商品标签
export function addGoodsTag(data) {
  return request({
    url: '/system/goodsTag',
    method: 'post',
    data: data
  })
}

// 修改商品标签
export function updateGoodsTag(data) {
  return request({
    url: '/system/goodsTag',
    method: 'put',
    data: data
  })
}

// 删除商品标签
export function delGoodsTag(id) {
  return request({
    url: '/system/goodsTag/' + id,
    method: 'delete'
  })
}
