import request from '@/utils/request'

// 查询住院陪诊订单列表
export function listZyphOrder(query) {
  return request({
    url: '/system/zyphOrder/list',
    method: 'get',
    params: query
  })
}

// 查询住院陪诊订单详细
export function getZyphOrder(id) {
  return request({
    url: '/system/zyphOrder/' + id,
    method: 'get'
  })
}

// 新增住院陪诊订单
export function addZyphOrder(data) {
  return request({
    url: '/system/zyphOrder',
    method: 'post',
    data: data
  })
}

// 修改住院陪诊订单
export function updateZyphOrder(data) {
  return request({
    url: '/system/zyphOrder',
    method: 'put',
    data: data
  })
}

// 删除住院陪诊订单
export function delZyphOrder(id) {
  return request({
    url: '/system/zyphOrder/' + id,
    method: 'delete'
  })
}
