import request from '@/utils/request'

// 查询诊前挂号订单列表
export function listZqghOrder(query) {
  return request({
    url: '/system/zqghOrder/list',
    method: 'get',
    params: query
  })
}

// 查询诊前挂号订单详细
export function getZqghOrder(id) {
  return request({
    url: '/system/zqghOrder/' + id,
    method: 'get'
  })
}

// 新增诊前挂号订单
export function addZqghOrder(data) {
  return request({
    url: '/system/zqghOrder',
    method: 'post',
    data: data
  })
}

// 修改诊前挂号订单
export function updateZqghOrder(data) {
  return request({
    url: '/system/zqghOrder',
    method: 'put',
    data: data
  })
}

// 删除诊前挂号订单
export function delZqghOrder(id) {
  return request({
    url: '/system/zqghOrder/' + id,
    method: 'delete'
  })
}
