import request from '@/utils/request'

// 查询预约陪诊订单列表
export function listOrder(query) {
  return request({
    url: '/system/yypzOrder/list',
    method: 'get',
    params: query
  })
}

// 查询预约陪诊订单详细
export function getOrder(id) {
  return request({
    url: '/system/yypzOrder/' + id,
    method: 'get'
  })
}

// 新增预约陪诊订单
export function addOrder(data) {
  return request({
    url: '/system/yypzOrder',
    method: 'post',
    data: data
  })
}

// 修改预约陪诊订单
export function updateOrder(data) {
  return request({
    url: '/system/yypzOrder',
    method: 'put',
    data: data
  })
}

// 删除预约陪诊订单
export function delOrder(id) {
  return request({
    url: '/system/yypzOrder/' + id,
    method: 'delete'
  })
}
