import request from '@/utils/request'

// 查询代办问诊订单列表
export function listDbwzOrder(query) {
  return request({
    url: '/system/dbwzOrder/list',
    method: 'get',
    params: query
  })
}

// 查询代办问诊订单详细
export function getDbwzOrder(id) {
  return request({
    url: '/system/dbwzOrder/' + id,
    method: 'get'
  })
}

// 新增代办问诊订单
export function addDbwzOrder(data) {
  return request({
    url: '/system/dbwzOrder',
    method: 'post',
    data: data
  })
}

// 修改代办问诊订单
export function updateDbwzOrder(data) {
  return request({
    url: '/system/dbwzOrder',
    method: 'put',
    data: data
  })
}

// 删除代办问诊订单
export function delDbwzOrder(id) {
  return request({
    url: '/system/dbwzOrder/' + id,
    method: 'delete'
  })
}
