import request from '@/utils/request'

// 查询代办买药订单列表
export function listDbmyOrder(query) {
  return request({
    url: '/system/dbmyOrder/list',
    method: 'get',
    params: query
  })
}

// 查询代办买药订单详细
export function getDbmyOrder(id) {
  return request({
    url: '/system/dbmyOrder/' + id,
    method: 'get'
  })
}

// 新增代办买药订单
export function addDbmyOrder(data) {
  return request({
    url: '/system/dbmyOrder',
    method: 'post',
    data: data
  })
}

// 修改代办买药订单
export function updateDbmyOrder(data) {
  return request({
    url: '/system/dbmyOrder',
    method: 'put',
    data: data
  })
}

// 删除代办买药订单
export function delDbmyOrder(id) {
  return request({
    url: '/system/dbmyOrder/' + id,
    method: 'delete'
  })
}
