import request from '@/utils/request'

// 查询代办挂号订单列表
export function listDbghOrder(query) {
  return request({
    url: '/system/dbghOrder/list',
    method: 'get',
    params: query
  })
}

// 查询代办挂号订单详细
export function getDbghOrder(id) {
  return request({
    url: '/system/dbghOrder/' + id,
    method: 'get'
  })
}

// 新增代办挂号订单
export function addDbghOrder(data) {
  return request({
    url: '/system/dbghOrder',
    method: 'post',
    data: data
  })
}

// 修改代办挂号订单
export function updateDbghOrder(data) {
  return request({
    url: '/system/dbghOrder',
    method: 'put',
    data: data
  })
}

// 删除代办挂号订单
export function delDbghOrder(id) {
  return request({
    url: '/system/dbghOrder/' + id,
    method: 'delete'
  })
}
