import request from '@/utils/request'

// 查询业务列表
export function listBusiness(query) {
  return request({
    url: '/system/business/list',
    method: 'get',
    params: query
  })
}

// 查询业务详细
export function getBusiness(id) {
  return request({
    url: '/system/business/' + id,
    method: 'get'
  })
}
// 查询业务详细
export function servicesGET(query) {
  return request({
    url: '/system/services/list',
    method: 'get',
    params: query
  })
}
// 新增业务
export function addBusiness(data) {
  return request({
    url: '/system/business',
    method: 'post',
    data: data
  })
}

// 修改业务
export function updateBusiness(data) {
  return request({
    url: '/system/business',
    method: 'put',
    data: data
  })
}

// 删除业务
export function delBusiness(id) {
  return request({
    url: '/system/business/' + id,
    method: 'delete'
  })
}

//获取服务详细信息
export function getServe(id) {
  return request({
    url: 'system/services/' + id,
    method: 'get'
  })
}

// 新增服务
export function addServe(data) {
  return request({
    url: '/system/services',
    method: 'post',
    data: data
  })
}

// 修改服务
export function updateServe(data) {
  return request({
    url: '/system/services',
    method: 'put',
    data: data
  })
}