import request from '@/utils/request'

// 查询陪诊员列表
export function listEmployees(query) {
  return request({
    url: '/merchant/employees/list',
    method: 'get',
    params: query
  })
}

// 查询陪诊员详细
export function getEmployees(id) {
  return request({
    url: '/merchant/employees/' + id,
    method: 'get'
  })
}

// 新增陪诊员
export function addEmployees(data) {
  return request({
    url: '/merchant/employees',
    method: 'post',
    data: data
  })
}

// 修改陪诊员
export function updateEmployees(data) {
  return request({
    url: '/merchant/employees',
    method: 'put',
    data: data
  })
}

// 删除陪诊员
export function delEmployees(id) {
  return request({
    url: '/merchant/employees/' + id,
    method: 'delete'
  })
}
