import request from '@/utils/request'

// 查询商户列表
export function listCompany(query) {
  return request({
    url: '/merchant/company/list',
    method: 'get',
    params: query
  })
}

// 查询商户详细
export function getCompany(id) {
  return request({
    url: '/merchant/company/' + id,
    method: 'get'
  })
}

// 新增商户
export function addCompany(data) {
  return request({
    url: '/merchant/company',
    method: 'post',
    data: data
  })
}

// 修改商户
export function updateCompany(data) {
  return request({
    url: '/merchant/company',
    method: 'put',
    data: data
  })
}

// 删除商户
export function delCompany(id) {
  return request({
    url: '/merchant/company/' + id,
    method: 'delete'
  })
}
