/*
 * @Author: ‘巴博尔’ 2164119982@qq.com
 * @Date: 2023-09-11 10:51:38
 * @LastEditors: ‘巴博尔’ 2164119982@qq.com
 * @LastEditTime: 2023-09-11 11:43:47
 * @FilePath: \peizhen-vue\src\api\mallManagement\order.js
 * @Description: 这是默认设置,请设置`customMade`, 打开koroFileHeader查看配置 进行设置: https://github.com/OBKoro1/koro1FileHeader/wiki/%E9%85%8D%E7%BD%AE
 */
import request from '@/utils/request'

// 查询商城订单列表
export function listOrder(query) {
  return request({
    url: '/system/storeOrder/list',
    method: 'get',
    params: query
  })
}

// 查询商城订单详细
export function getOrder(id) {
  return request({
    url: '/system/order/' + id,
    method: 'get'
  })
}

// 新增商城订单
export function addOrder(data) {
  return request({
    url: '/system/order',
    method: 'post',
    data: data
  })
}

// 修改商城订单
export function updateOrder(data) {
  return request({
    url: '/system/order',
    method: 'put',
    data: data
  })
}

// 删除商城订单
export function delOrder(id) {
  return request({
    url: '/system/order/' + id,
    method: 'delete'
  })
}
