import request from '@/utils/request'

// 查询商城提现审批列表
export function listIncome(query) {
  return request({
    url: '/system/income/list',
    method: 'get',
    params: query
  })
}

// 查询商城提现审批详细
export function getIncome(id) {
  return request({
    url: '/system/income/' + id,
    method: 'get'
  })
}

// 新增商城提现审批
export function addIncome(data) {
  return request({
    url: '/system/income',
    method: 'post',
    data: data
  })
}

// 修改商城提现审批
export function updateIncome(data) {
  return request({
    url: '/system/income',
    method: 'put',
    data: data
  })
}

// 删除商城提现审批
export function delIncome(id) {
  return request({
    url: '/system/income/' + id,
    method: 'delete'
  })
}
