/*
 * @Author: ‘巴博尔’ 2164119982@qq.com
 * @Date: 2023-10-09 14:59:34
 * @LastEditors: ‘巴博尔’ 2164119982@qq.com
 * @LastEditTime: 2023-10-09 18:59:06
 * @FilePath: \peizhen-vue\src\api\index.js
 * @Description: 这是默认设置,请设置`customMade`, 打开koroFileHeader查看配置 进行设置: https://github.com/OBKoro1/koro1FileHeader/wiki/%E9%85%8D%E7%BD%AE
 */
import request from "@/utils/request";

// 新增用户统计
export function dataUserGet(query) {
  return request({
    url: "/system/data/dataUser",
    method: "get",
    params: query,
  });
}

// 新增陪诊员统计
export function dataEmployeesGet(query) {
  return request({
    url: "/system/data/dataEmployees",
    method: "get",
    params: query,
  });
}

// 订单销售额
export function saleroomGet(query) {
  return request({
    url: "/system/data/saleroom",
    method: "get",
    params: query,
  });
}

// 平台收益
export function platformRevenueGet(query) {
  return request({
    url: "/system/data/platformRevenue",
    method: "get",
    params: query,
  });
}

// 订单量
export function orderQuantityGet(query) {
  return request({
    url: "/system/data/orderQuantity",
    method: "get",
    params: query,
  });
}

// 数据总览柱状图
export function orderQuantityEchartsGet(query) {
  return request({
    url: `/system/data/findOrderColumnarVoList`,
    method: "get",
    params: query,
  });
}

// 新增陪诊员
export function addEmployeesPost(data) {
  return request({
    url: "/merchant/employees",
    method: "post",
    data: data,
  });
}

// 陪诊员详情
export function employeesDetailsGet(query) {
  return request({
    url: `/merchant/employees/${query.id}`,
    method: "get",
  });
}

// 陪诊员修改
export function employeesUpdatePut(data) {
  return request({
    url: "/merchant/employees/EmployeesUpdate",
    method: "put",
    data: data,
  });
}

// 陪诊员冻结
export function switchStatusPut(data) {
  return request({
    url: `/merchant/app/employees/switchStatus?emId=${data.emId}`,
    method: "put",
    // data: data,
  });
}

// 设置为陪护人员
export function switchIdentityPut(data) {
  return request({
    url: `/merchant/app/employees/switchIdentity?emId=${data.emId}`,
    method: "put",
    // data: data,
  });
}

// 所属商户
export function companyPlistGet(query) {
  return request({
    url: `/merchant/company/Plist`,
    method: "get",
    params: query,
  });
}

// 设置时间
export function employeesSetWorkHourPut(data) {
  return request({
    url: "/merchant/app/employees/setWorkHour",
    method: "put",
    data: data,
  });
}

// 机构
export function companyListGet(query) {
  return request({
    url: `/system/data/companyList`,
    method: "get",
    params: query,
  });
}
