/*
 * @Author: ‘巴博尔’ 2164119982@qq.com
 * @Date: 2023-09-13 14:18:29
 * @LastEditors: ‘巴博尔’ 2164119982@qq.com
 * @LastEditTime: 2023-09-13 14:25:22
 * @FilePath: \peizhen-vue\src\api\income\index.js
 * @Description: 这是默认设置,请设置`customMade`, 打开koroFileHeader查看配置 进行设置: https://github.com/OBKoro1/koro1FileHeader/wiki/%E9%85%8D%E7%BD%AE
 */
import request from '@/utils/request'

// 查询商城提现审批列表
export function listIncome(query) {
  return request({
    url: '/system/storeIncome/list',
    method: 'get',
    params: query
  })
}

// 查询商城提现审批详细
export function getIncome(id) {
  return request({
    url: '/system/storeIncome/' + id,
    method: 'get'
  })
}

// 新增商城提现审批
export function addIncome(data) {
  return request({
    url: '/system/storeIncome',
    method: 'post',
    data: data
  })
}

// 修改商城提现审批
export function updateIncome(data) {
  return request({
    url: '/system/storeIncome',
    method: 'put',
    data: data
  })
}

// 删除商城提现审批
export function delIncome(id) {
  return request({
    url: '/system/storeIncome/' + id,
    method: 'delete'
  })
}
