import request from "@/utils/request";

// 查询用户退款列表
export function listUserRefund(query) {
  return request({
    url: "/system/userRefund/list",
    method: "get",
    params: query,
  });
}

// 查询用户退款详细
export function getUserRefund(id) {
  return request({
    url: "/system/userRefund/" + id,
    method: "get",
  });
}

// 新增用户退款
export function addUserRefund(data) {
  return request({
    url: "/system/userRefund",
    method: "post",
    data: data,
  });
}

// 修改用户退款
export function updateUserRefund(data) {
  return request({
    url: "/system/userRefund",
    method: "put",
    data: data,
  });
}

// 删除用户退款
export function delUserRefund(id) {
  return request({
    url: "/system/userRefund/" + id,
    method: "delete",
  });
}

// 通过/拒绝
export function refundPUT(data) {
  return request({
    url: "/system/userRefund/refund",
    method: "put",
    data: data,
  });
}
