import request from '@/utils/request'

// 查询支付订单列表
export function listPaymentRecord(query) {
  return request({
    url: '/system/paymentRecord/list',
    method: 'get',
    params: query
  })
}

// 查询支付订单详细
export function getPaymentRecord(id) {
  return request({
    url: '/system/paymentRecord/' + id,
    method: 'get'
  })
}

// 新增支付订单
export function addPaymentRecord(data) {
  return request({
    url: '/system/paymentRecord',
    method: 'post',
    data: data
  })
}

// 修改支付订单
export function updatePaymentRecord(data) {
  return request({
    url: '/system/paymentRecord',
    method: 'put',
    data: data
  })
}

// 删除支付订单
export function delPaymentRecord(id) {
  return request({
    url: '/system/paymentRecord/' + id,
    method: 'delete'
  })
}
