import request from '@/utils/request'

// 查询陪诊员/商户提现列表
export function listIncome(query) {
  return request({
    url: '/system/income/list',
    method: 'get',
    params: query
  })
}

// 查询陪诊员/商户提现详细
export function getIncome(id) {
  return request({
    url: '/system/income/' + id,
    method: 'get'
  })
}

// 新增陪诊员/商户提现
export function addIncome(data) {
  return request({
    url: '/system/income',
    method: 'post',
    data: data
  })
}

// 修改陪诊员/商户提现
export function updateIncome(data) {
  return request({
    url: '/system/income',
    method: 'put',
    data: data
  })
}

// 删除陪诊员/商户提现
export function delIncome(id) {
  return request({
    url: '/system/income/' + id,
    method: 'delete'
  })
}
